/*----------------------------------------------------------------------------
 * Name     : BC5602Test.c
 * Purpose  :
 * Note(s)  : 
 *----------------------------------------------------------------------------*/

#include		"bc5602Test.h" 
#include		"timer.h"

uc16	CarrierRegsSetup[]=
{
	B2W(CONFIG_REGS,(_AGC_EN_|_DIR_EN_|REGS_BANK2)),	/* BANK 2 */
	B2W(0x29,0x10),
	B2W(CONFIG_REGS,(_AGC_EN_|_DIR_EN_|REGS_BANK0))		/* BANK 0 */
};
/*----------------------------------------------------------------------------*/
/*	 BC5602 Carrier Active                                       					*/
/*----------------------------------------------------------------------------*/
void BC5602CarrierActive(void)
{
	BC5602WriteRegister(OPM_CTL_REGS,_ACAL_EN_);
	do{ Delay10us(10); }while(BC5602ReadRegister(OPM_CTL_REGS) & _ACAL_EN_);
	
	BC5602WriteRegister(OPM_CTL_REGS,0x03); 	/* ACAL_EN=0,RTX_EN=0,RTX_SEL=1,SX_EN=1 */
	Delay10us(5);
	BC5602WriteRegister(OPM_CTL_REGS,0x07);  	/* ACAL_EN=0,RTX_EN=1,RTX_SEL=1,SX_EN=1 */
}
/*----------------------------------------------------------------------------*/
/*	 BC5602 Carrier Inactive                                       				*/
/*----------------------------------------------------------------------------*/
void BC5602CarrierInactive(void)
{
	BC5602WriteRegister(OPM_CTL_REGS,0x01);  	/* ACAL_EN=0,RTX_EN=0,RTX_SEL=0,SX_EN=1 */
	Delay10us(5);
	BC5602WriteRegister(OPM_CTL_REGS,0x00);  	/* ACAL_EN=0,RTX_EN=0,RTX_SEL=0,SX_EN=0 */
}
/*----------------------------------------------------------------------------*/
/*	 BC5602 Carrier register setup                                       		*/
/*----------------------------------------------------------------------------*/
void BC5602CarrierRegsSetup(void)
{
	BC5602WriteConstRegister((sizeof(CarrierRegsSetup)/2),CarrierRegsSetup);
}
